
primitive U_FJK_P_SB_NO_QN (QN, J, K, CP, SB, NOTIFIER_REG); 
 

    output QN;
    reg    QN;  
    input  NOTIFIER_REG,
           J,K,
            CP,                                  // CLOCK.
            SB;                                  // set INPUT.
// FUNCTION : POSITIVE EDGE TRIGGERED J K FLIP FLOP, WITH
//            ASYNCHRONOUS ACTIVE LOW SET  ( QN OUTPUT UDP )  


    table
      // J   K   CP  SB      NOTIFIER_REG  :  Qtn : Qtn+1

         0   0  (01)  1         ?          :   ?  :   - ;         // Output retains the 
                                                 // present state if both 
                                                 // J and K are 0.

         0   1  (01)  1         ?          :   ?  :   1 ;         // Clocked J and K.
         1   0  (01)  1         ?          :   ?  :   0 ;    

         1   0  (01)  x         ?          :   ?  :   0 ;         // pessimism
         ?   ?   ?    x         ?          :   0  :   0 ;         // pessimism

         1   1  (01)  1         ?          :   1  :   0 ;         // Clocked toggle.
         1   1  (01)  1         ?          :   0  :   1 ;

         1   ?  (01)  x         ?          :   1  :   0 ;         // pessimism

         0   0  (x1)  1         ?          :   ?  :   - ;         //possible clocked JK
         0   1  (x1)  1         ?          :   1  :   1 ;   
         1   0  (x1)  1         ?          :   0  :   0 ;
         0   0  (0x)  1         ?          :   ?  :   - ;
         0   1  (0x)  1         ?          :   1  :   1 ;
         1   0  (0x)  1         ?          :   0  :   0 ;


         *   ?   ?    ?         ?          :   ?  :   - ;         // Insensitive to 
         ?   *   ?    ?         ?          :   ?  :   - ;         // transitions on J and K
                                                 // with steady clock.
         ?   ? (?0)   1         ?          :   ?  :   - ;         //ignore falling clock.
         ?   ? (1x)   1         ?          :   ?  :   - ;
                                         
         x   0   r    1         ?          :   0  :   0 ;         // reducing pessimism for unknown J 
         x   1   r    1         ?          :   0  :   1 ;         // reducing pessimism for unknown J 
         0   x   r    1         ?          :   1  :   1 ;         // reducing pessimism for unknown K 
         1   x   r    1         ?          :   1  :   0 ;         // reducing pessimism for unknown K 

         x   0  (x1)  1         ?          :   0  :   0 ;        //possible clocked with
         0   x  (x1)  1         ?          :   1  :   1 ;        //possible J & K                                 
         x   0  (0x)  1         ?          :   0  :   0 ;
         0   x  (0x)  1         ?          :   1  :   1 ;

         ?   ?   ?    0         ?          :   ?  :   0 ;         // set. 

         ?   ?   ?   (?1)       ?          :   ?  :   - ;         // Insensitive to a rising
         ?   ?   ?    ?         *          :   ?  :   x ;         // edge on SET .


    endtable

endprimitive
